IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[EpisodeByFillerOrderNumberGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[EpisodeByFillerOrderNumberGet]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: 22 September 2015
-- Description: Gets a specific record/records from the Episode Table using Filler Order Number
-- =============================================
CREATE PROCEDURE [hips].[EpisodeByFillerOrderNumberGet] 
(
	@FillerOrderNumber VARCHAR(100)
)
AS
BEGIN
SELECT DISTINCT e.EpisodeId
	, e.PatientId
	, e.SourceSystemEpisodeId
	, e.AdmissionDate
	, e.AdmissionReason
	, e.DischargeDate
	, e.ResponsibleProviderId
	, e.EpisodeTypeId
	, et.Description AS EpisodeType
	, e.EpisodeLifecycleId
	, ec.Description AS EpisodeLifecycle
	, e.ConsentWithdrawn
	, e.Ward
	, e.Room
	, e.Bed
	, e.DateCreated
	, e.UserCreated
	, e.DateModified
	, e.UserModified
FROM hips.Episode e
LEFT JOIN [hips].[EpisodeType] AS et on et.EpisodeTypeId = e.EpisodeTypeId
LEFT JOIN [hips].[EpisodeLifecycle] AS ec on ec.EpisodeLifecycleId = e.EpisodeLifecycleId
INNER JOIN [hips].[CdaSetNumber]  AS csn on e.EpisodeId = csn.EpisodeId
INNER JOIN [hips].[FillerOrderNumber] AS fon on csn.CdaSetNumberId = fon.CdaSetNumberId
WHERE fon.FillerOrderNumber = @FillerOrderNumber
ORDER BY e.AdmissionDate DESC

END
GO
